#!/bin/bash

# 本文件，所有IS_开头的变量，均是布尔值，配置时请使用标准的【true | false】


# 执行：
## Mac: 终端打开文件
## Windows:
### 1、下载 Git Bash
### 2、进入bin目录: cd ./bin
### 3、执行命令: sh ./downLowCode.sh
# 注：需要赋予脚本运行权限


###
 # 
 # ----------------------- 项目使用的Mybrick发布模式，至少开启一个！ ----------------------- 
 # 
###

# 默认
IS_PROD=false
MODE_DIR_PROD="prod"

# 自定义域名
IS_CUSTOM_HOST=true
MODE_DIR_CUSTOM="__USE_CUSTOM_HOST__"

# 检查是否至少开启一个发布模式
if [ "$IS_CUSTOM_HOST" = false ] && [ "$IS_PROD" = false ]; then
  echo "Error: 请确认低码的发布模式, 【默认、自定义域名】至少开启一个!"
  exit 1
fi


###
 # 
 # ----------------------- 下载最新低码资源，并解压.zip文件 ----------------------- 
 # 
###

# 目标.zip文件的URL
## 在微管理平台上找对应的项目，【下载最新版本HTML】按钮链接: http://work.manateeai.com/microfrontends/index.html#/projects
FILE_URL="http://work.manateeai.com/biz/modularityExport/project1698217845514818/downCurrentVersionHtmlList?projectId=55"

# 下载到本地的zip文件名称，任取
ZIP_FILE_NAME="downloaded_file.zip"

# 解压zip的临时目录
UNZIP_DIR="./lowcodeUnzip"

# 下载.zip文件
echo "下载: 远程zip文件..."
curl -o "$ZIP_FILE_NAME" "$FILE_URL" || { echo "Error: 下载zip文件, 失败!"; exit 1; }

# 解压文件到临时目录
echo "解压: zip文件..."
unzip -o "$ZIP_FILE_NAME" -d "$UNZIP_DIR" || { echo "Error: 解压zip文件, 失败!"; exit 1; }


###
 # 
 # ----------------------- 移除不需要的发布模式 ----------------------- 
 # 
###

# 不同发布模式的低码资源目录
PROD_FILE_DIR="$UNZIP_DIR/$MODE_DIR_PROD"
CUSTOM_FILE_DIR="$UNZIP_DIR/$MODE_DIR_CUSTOM"

# 移除不需要的发布模式
if [ "$IS_PROD" = false ]; then
  rm -rf "$PROD_FILE_DIR" || { echo "Error: 移除prod模式目录, 失败!"; exit 1; }
fi
if [ "$IS_CUSTOM_HOST" = false ]; then
  rm -rf "$CUSTOM_FILE_DIR" || { echo "Error: 移除custom模式目录, 失败!"; exit 1; }
fi


###
 # 
 # ----------------------- 备份原有低码文件 ----------------------- 
 #
###

# 是否开启备份
IS_BACKUP=false

# 备份目录
BACKUP_PARENT_DIR="../lowcodeBackup"

# 备份文件地址
BACKUP_DIR="${BACKUP_PARENT_DIR}/$(date +%Y%m%d-%H%M%S).tar.gz"

# 本地低码资源目录
FINAL_PARENT_DIR="../public"
#FINAL_PARENT_DIR="/www/wwwroot/test.daikinzc.helloaiwork.com/dist-test"

# 备份
if [ -d "$FINAL_PARENT_DIR" ] && [ "$IS_BACKUP" = true ]; then
  # 创建备份目录
  echo "正在创建备份目录: $BACKUP_PARENT_DIR..."
  mkdir -p "$BACKUP_PARENT_DIR" || { echo "Error: 创建备份目录, 失败!"; exit 1; }

  # 备份目录并压缩
  echo "正在备份目录: $FINAL_PARENT_DIR , 并压缩到: $BACKUP_DIR..."
  tar -czf "$BACKUP_DIR" -C "$FINAL_PARENT_DIR" . || { echo "Error: 压缩备份目录, 失败!"; exit 1; }
fi

###
 # 
 # ----------------------- 将项目低码产物更新 ----------------------- 
 #
###

# 低码页面文件目录
LOWCODE_PAGE_DIR="$FINAL_PARENT_DIR/microfrontends"

# 删除旧的低码页面文件
rm -rf "$LOWCODE_PAGE_DIR"/* || { echo "Error: 删除旧的低码页面文件, 失败!"; exit 1; }

# 将下载解压的所有最新文件，放到项目中
echo "正在移动低码文件到: $LOWCODE_PAGE_DIR..."
mkdir -p "$LOWCODE_PAGE_DIR"
mv "$UNZIP_DIR"/* "$LOWCODE_PAGE_DIR" || cp -r "$UNZIP_DIR"/* "$LOWCODE_PAGE_DIR" || { echo "Error: 移动低码文件, 失败!"; exit 1; }

# 删除解压zip的临时目录
rm -rf "$ZIP_FILE_NAME" || { echo "Error: 删除临时zip文件, 失败!"; exit 1; }
rm -rf "$UNZIP_DIR" || { echo "Error: 删除解压zip的临时目录, 失败!"; exit 1; }


###
 # 
 # ----------------------- 将低码mfs资源文件，移动到项目低码静态资源加载目录 ----------------------- 
 #
###

# 是否需要移动mfs到FINAL_PARENT_DIR根目录下
IS_REMOVE_MFS=false

if [ "$IS_REMOVE_MFS" = true ]; then
  # 低码平台定义的静态资源目录文件名
  LOWCODE_MFS="mfs"

  # 项目低码静态资源加载目录
  LOWCODE_MFS_DIR="$FINAL_PARENT_DIR/$LOWCODE_MFS"

  # 解压的静态资源目录
  LOWCODE_MFS_PROD_DIR="$LOWCODE_PAGE_DIR/$MODE_DIR_PROD/$LOWCODE_MFS"
  LOWCODE_MFS_CUSTOM_DIR="$LOWCODE_PAGE_DIR/$MODE_DIR_CUSTOM/$LOWCODE_MFS"

  # 删除LOWCODE_MFS_DIR目录下的文件
  rm -rf "$LOWCODE_MFS_DIR"/* || { echo "Error: 删除旧的mfs文件, 失败!"; exit 1; }

  # 创建LOWCODE_MFS_DIR目录
  mkdir -p "$LOWCODE_MFS_DIR"

  # 将低码所有mfs静态资源，放到项目可加载目录下
  if [ -d "$LOWCODE_MFS_PROD_DIR" ]; then
    echo "移动: prod_mfs文件, 从: $LOWCODE_MFS_PROD_DIR 到: $LOWCODE_MFS_DIR..."
    mv "$LOWCODE_MFS_PROD_DIR"/* "$LOWCODE_MFS_DIR" || cp -r "$LOWCODE_MFS_PROD_DIR"/* "$LOWCODE_MFS_DIR" || { echo "Error: 移动mfs_prod文件, 失败!"; exit 1; }
    rm -rf "$LOWCODE_MFS_PROD_DIR" || { echo "Error: 删除prod_mfs目录, 失败!"; exit 1; }
  fi
  if [ -d "$LOWCODE_MFS_CUSTOM_DIR" ]; then
    echo "移动: custom_mfs文件, 从: $LOWCODE_MFS_CUSTOM_DIR 到: $LOWCODE_MFS_DIR..."
    mv "$LOWCODE_MFS_CUSTOM_DIR"/* "$LOWCODE_MFS_DIR" || cp -r "$LOWCODE_MFS_CUSTOM_DIR"/* "$LOWCODE_MFS_DIR" || { echo "Error: 移动mfs_custom文件, 失败!"; exit 1; }
    rm -rf "$LOWCODE_MFS_CUSTOM_DIR" || { echo "Error: 删除custom_mfs目录, 失败!"; exit 1; }
  fi
fi


###
 # 
 # ----------------------- 移除低码下载包中的历史版本 ----------------------- 
 #
###

# 是否只保留最新版本文件
IS_KEEP_LAST_VERSION=true

# 版本目录文件名
LOWCODE_VERSION="version"

# 版本文件目录
LOWCODE_VERSION_PROD_DIR="$LOWCODE_PAGE_DIR/$MODE_DIR_PROD/$LOWCODE_VERSION"
LOWCODE_VERSION_CUSTOM_DIR="$LOWCODE_PAGE_DIR/$MODE_DIR_CUSTOM/$LOWCODE_VERSION"

# 移除版本文件
if [ "$IS_KEEP_LAST_VERSION" = true ]; then
  rm -rf "$LOWCODE_VERSION_PROD_DIR" || { echo "Error: 删除版本文件prod_version目录, 失败!"; exit 1; }
  rm -rf "$LOWCODE_VERSION_CUSTOM_DIR" || { echo "Error: 删除版本文件custom_version目录, 失败!"; exit 1; }
fi


echo "Success: 低码资源处理, 成功!"
exit 1